/* Antarmuka dengan Sensor PIR - Trainer Internet of Things
 * Project : Deteksi gerakan dengan Sensor PIR berbasis IoT
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN Sensor PIR terhubung ke PIN D0 NodeMCU
#define PIR_PIN D0

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  pinMode(PIR_PIN, INPUT);// Pin PIR sebagai Input 
  
  lcd.init();          // Inisialisasi LCD
  lcd.backlight();     // Menyalakan Backlight LCD
  
  // Menampilkan Teks pada LCD
  lcd.setCursor(0,0); lcd.print("Trainer Kit IoT");  
  lcd.setCursor(0,1); lcd.print("Connecting-WiFi");
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD
}

void loop() { 
  // Mengatur kursor pada kolom pertama baris pertama
  // Menampilkan teks
  lcd.setCursor(0, 0);
  lcd.print("Deteksi Gerakan:");

  // Jika PIR mendeteksi gerakan output bernilai HIGH
  // Mencetak teks jika gerakan terdeksi dan tidak terdeteksi
  // Mengirim data gerakan ke database *user/indicator1
  if(digitalRead(PIR_PIN)==HIGH){
    lcd.setCursor(0,1); lcd.print("Gerak Terdeteksi");
    Firebase.setString(fbdo, "/" + user + "/indicator1", "Gerakan Terdeteksi");
  } else {
    lcd.setCursor(0,1); lcd.print("Tidak Terdeteksi");
    Firebase.setString(fbdo, "/" + user + "/indicator1", "Tidak Terdeteksi"); 
  } 
}
